import java.time.LocalDate

class Person(
	var name: String,
	val geburtstagTag: Int,
	val geburtstagMonat: Int,
	val geburtsjahr: Int
) {
	fun berechneAlter(): Int {
		val heute = LocalDate.now()
		val geburtstag = LocalDate.of(geburtsjahr, geburtstagMonat, geburtstagTag)
		return geburtstag.until(heute).years
	}

	fun istVolljaehrig(): Boolean {
		return berechneAlter() >= 18
	}

	fun druckeInfo() {
		println("$name, geboren am %02d.%02d.%04d, ist %d Jahre alt.".format(geburtstagTag, geburtstagMonat, geburtsjahr, berechneAlter()))
	}

	fun berechneAlterAm(tag: Int, monat: Int, jahr: Int): Int {
		val referenzdatum = LocalDate.of(jahr, monat, tag)
		val geburtstag = LocalDate.of(geburtsjahr, geburtstagMonat, geburtstagTag)
		return geburtstag.until(referenzdatum).years
	}
}